﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport wydan</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
		<script runat="server"> 

            public enum SortowanieWedług { WgKoduOdbiorcy, WgNazwyOdbiorcy }

            public class ParametryContext : ContextBase {
                public ParametryContext(Context cx)
                    : base(cx) {
                }

                [Priority(10)]
                public Kontrahent Odbiorca {
                    get { return (Kontrahent)Context[typeof(Kontrahent), false]; }
                    set { Context[typeof(Kontrahent)] = value; }
                }
                
                SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyOdbiorcy;

                [DefaultWidth(50)]
                [Priority(20)]
                public SortowanieWedług SortujWedług {
                    get { return sortujWedług; }
                    set {
                        sortujWedług = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public bool IsReadOnlySortujWedług() {
                    return Odbiorca!=null;
                }
                /*
				private bool _ignorujZaliczkowe = true;

				[Soneta.Tools.Priority(30)]
				public bool IgnorujZaliczkowe
				{
					get
					{
						return this._ignorujZaliczkowe;
					}
					set
					{
						this._ignorujZaliczkowe = value;
						OnChanged(EventArgs.Empty);
					}
				}
                */
			}

            ParametryContext parametry;

            [Context]
            public ParametryContext Parametry {
                get { return parametry; }
                set { parametry = value; }
            }

            class NazwaComparer : IComparer {
                public int Compare(object obj1, object obj2) {
                    Total t1 = (Total)obj1;
                    Total t2 = (Total)obj2;
                    string s1 = t1.OdbiorcaNazwa;
                    string s2 = t2.OdbiorcaNazwa;
                    int cmp = s1.CompareTo(s2);
                    if (cmp != 0) return cmp;
                    return t1.Towar.Nazwa.CompareTo(t2.Towar.Nazwa);                    
                }
            }

            class KodComparer : IComparer {
                public int Compare(object obj1, object obj2) {
                    Total t1 = (Total)obj1;
                    Total t2 = (Total)obj2;
                    string s1 = t1.OdbiorcaKod;
                    string s2 = t2.OdbiorcaKod;
                    int cmp = s1.CompareTo(s2);
                    if (cmp != 0) return cmp;
                    return t1.Towar.Nazwa.CompareTo(t2.Towar.Nazwa);
                }
            }

    	    public class Klucz {
                readonly Towar towar;
                readonly Kontrahent odbiorca;
                public Klucz(PozycjaDokHandlowego pozycja) {
                    this.towar = pozycja.Towar;
                    this.odbiorca = pozycja.Dokument.Odbiorca;
                }
                public override bool Equals(object obj) {
                    Klucz klucz = obj as Klucz;
                    if (klucz == null) return false;
                    return towar == klucz.towar && odbiorca == klucz.odbiorca;
                }
                public override int GetHashCode() {
                    return 17 * towar.GetHashCode() + odbiorca.GetHashCode();
                }
            }


            public class Total {
                readonly Towar towar;
                readonly Kontrahent odbiorca;
                Quantity ilość;
                decimal netto;
                public Total(Towar towar, Kontrahent odbiorca) {
                    this.towar = towar;
                    this.odbiorca = odbiorca;
                }
                SumaPozycjiWorker spw = new SumaPozycjiWorker();
                public void Add(PozycjaDokHandlowego pozycja) {
                    spw.Pozycja = pozycja;
                    netto += spw.Netto;
                    ilość += pozycja.ZmianaMagazynu.Ilość;
                }
                public Towar Towar {
                    get { return towar; }
                }
                public Kontrahent Odbiorca {
                    get { return odbiorca; }
                }
                public string OdbiorcaNazwa {
                    get { return odbiorca != null ? odbiorca.Nazwa : string.Empty; }
                }
                public string OdbiorcaKod {
                    get { return odbiorca != null ? odbiorca.Kod : string.Empty; }
                }
                public decimal Netto {
                    get { return netto; }
                }
                public Quantity Ilość {
                    get { return ilość; }
                }
                public double ŚredniaCena {
                    get { return Soneta.Tools.Math.Round((double)netto / ilość.Value, Towar.Precyzja); }
                }
            }

            void OnContextLoad(Object sender, EventArgs args) {
                Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
                if (pars.Okres != Soneta.Types.FromTo.All)
                    ReportHeader.Title += "|Okres: <strong>" + pars.Okres.ToString() + "</strong>";
                if (pars.Definicja != null)
                    ReportHeader.Title += "|Definicja: <strong>" + pars.Definicja.ToString() + "</strong>";

                Row[] rows = (Row[])dc[typeof(Row[])];
                Hashtable result = new Hashtable();
                foreach (DokumentHandlowy dokument in rows) {
				  //if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                    if (dokument.Definicja.DuplikatWartosci) continue;
                    if (dokument.Kontrahent == null) continue;
                    if (Parametry.Odbiorca != null && Parametry.Odbiorca != dokument.Odbiorca) continue;

                    foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                        Klucz klucz = new Klucz(pozycja);
                        Total t = (Total)result[klucz];
                        if (t == null) {
                            t = new Total(pozycja.Towar, pozycja.Dokument.Odbiorca);
                            result.Add(klucz, t);
                        }
                        t.Add(pozycja);
                    }
                }

                ArrayList lista = new ArrayList(result.Values);
                switch (Parametry.SortujWedług) {
                    case SortowanieWedług.WgKoduOdbiorcy:
                        lista.Sort(new KodComparer());
                        break;
                    case SortowanieWedług.WgNazwyOdbiorcy:
                        lista.Sort(new NazwaComparer());
                        break;
                }
                Grid.DataSource = lista;
            }

		</script>
	<body>
		<form method="post" runat="server" action="#">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Raport wydań wg odbiorców i towarów|{0}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
				runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember0="DokHandloweViewInfo+WParams.InformacjaStanu"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" GroupData0="Odbiorca" GroupLine="Odbiorca: {0}" EncodeHTML="true">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Towar.Nazwa" Caption="Towar" NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="17" DataMember="Towar.Kod" Caption="Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Ilość.Value" Caption="Ilość" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="8" Align="Center" DataMember="Towar.Jednostka" Total="Sum" Caption="jm."
						NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="ŚredniaCena" Caption="Średnia cena" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</html>

